﻿using System.Linq;

namespace VA.PPMS.IWS.MappingService.Helpers
{
    public static class LuhnHelper
    {
        private const int NpiPrefixConstant = 24;

        public static bool NpiCheck(this string number)
        {
            // Check number length
            if (number.Length != 10) return false;

            // Luhn check
            var digits = number.Select(c => c - '0').ToArray();
            var result = GetNpiCheckValue(digits);
            return result == 0;
        }

        public static bool DeaCheck(this string deaNumber)
        {
            // Check number length
            if (deaNumber.Length != 9)
                return false;

            // Parse number value
            var number = deaNumber.Substring(2, 6);
            var checkDigit = CharToInt(deaNumber.Substring(deaNumber.Length - 1));

            // Luhn check
            var digits = number.Select(c => c - '0').ToArray();
            var result = GetDeaCheckValue(digits);
            return result == checkDigit;
        }

        // For more info, see https://www.cms.gov/Regulations-and-Guidance/Administrative-Simplification/NationalProvIdentStand/Downloads/NPIcheckdigit.pdf
        private static int GetNpiCheckValue(int[] digits)
        {
            return (digits.Select((d, i) => i % 2 == digits.Length % 2 ? ((2 * d) % 10) + d / 5 : d).Sum() + NpiPrefixConstant) % 10;
        }

        private static int GetDeaCheckValue(int[] digits)
        {
            return (digits.Select((d, i) => i % 2 == 0 ? d : d * 2).Sum()) % 10;
        }

        private static int CharToInt(string number)
        {
            if (int.TryParse(number, out var result))
            {
                return result;
            }

            return -1;
        }
    }
}